//
//  B5EncryptedKeySet.h
//  ApplicationFrameworks
//
//  Created by Rick Fillion on 2015-04-16.
//
//

#import <Foundation/Foundation.h>
#import <OnePasswordDataModel/OnePasswordDataModel.h>

@interface B5EncryptedKeySet : B5DatabaseObject

// Database Properties
@property (nonatomic, assign) OPID accountId;
@property (nonatomic, copy) NSString *uuid;
@property (nonatomic, assign) NSUInteger serialNumber;
@property (nonatomic, copy) NSString *encryptedBy;
@property (nonatomic, copy) NSDictionary *encryptedSymmetricKey;
@property (nonatomic, copy) NSDictionary *encryptedPrivateKey;
@property (nonatomic, copy) NSDictionary *publicKeyDictionary;

//
@property (nonatomic, readonly) OPPublicKey *publicKey;

- (instancetype)initExistingWithID:(OPID)oid userAccountID:(OPID)accountID encryptedKeySetJSON:(NSDictionary *)encryptedKeySetJSON;

@end
